package simplegame;

public class Highscore {

	// private int size = 10;
	
	/**
	 * Array to store highscore information. 
	 * highscore[0] = top score
	 * highscore[9] = lowest highscore
	 */
	private Player[] highscore; 

	public Highscore(int s) {
		// size = s;
		highscore = new Player[s];
		for (int i=0; i<s; ++i)
		{	highscore[i] = new Player("<empty>",0);
		}
	}
	
	/**
	 * Runs through the array in a for loop and prints the scores. 
	 * The top score should be printed first.  
	 */
	public void showHighscore() {
		System.out.println("*** HIGHSCORE ***");
		for (int i=0; i<highscore.length; ++i)
			System.out.println(highscore[i]);
	}
	
	/**
	 * Enters a new score into the highscore array. 
	 * The order must be maintained and no lower score should ever replace a higher one. 
	 */
	public void insert(Player p) {
		if (p.score > highscore[highscore.length-1].score) { // good enough for a highscore?
			int pos = 0;
			while (p.score < highscore[pos].score)
				++pos;
			for (int i=highscore.length-2; i>=pos; --i)
				highscore[i+1] = highscore[i];
			highscore[pos] = p;
		}
	}
	
	/**
	 * Should show a valid highscore table.
	 * Especially the values must always appear in descending order. 
	 */
	public void test() {
		for (int i=0; i<100; i+=10)
			insert(new Player("F"+i,i));
		insert(new Player("Ramona",55));
		showHighscore();
		insert(new Player("Klara",15));
		showHighscore();
		insert(new Player("Tamara",95));
		showHighscore();
		insert(new Player("Julia",5));
		showHighscore();		
	}

}
