package Beer;

public class BeersIndexed extends Beers {

	BeerRecord[] beers;
	int used;
	
	BeersIndexed (){ 
		beers = new BeerRecord[7]; // initial size
	}
	
	public double FillLevel()
	{
		return (double)used / beers.length;
	}
	
	void Grow(int size)
	{
		int newSize = beers.length;
		while (newSize < size) newSize *= 2;
		BeerRecord[] newBeers = new BeerRecord[newSize];
		for (int i=0; i < beers.length; ++i)
			newBeers[i] = beers[i];
		beers = newBeers;
	}
	
	public void Put(BeerRecord beer)
	{
		int position = beer.id;
		if (position >= beers.length)
			Grow(position+1);
		if (beers[position] == null)
			used++;
		beers[position] = beer;
	}
	
	public BeerRecord Get(int id)
	{
		int position = id;
		if (position >= beers.length) return null;
		return beers[position];
	}
	
	public boolean Delete(int id)
	{
		int position = id;
		if (position >= beers.length) 
			return false;
		if (beers[position] != null)
		{
			beers[position] = null;
			used--;
			return true;
		}
		else
			return false;
	}
}
