package Beer;

// simple hash table implementation for Beer
// linear probing, fill level limited to 3/4
public class BeersHashed extends Beers{
	BeerRecord[] beers;
	int used;
	BeerRecord free; // special element for deletion
	int collisions;
	
	BeersHashed (){ 
		beers = new BeerRecord[7]; // initial size
		free = new BeerRecord();
		used= 0;
		collisions = 0;
	}
	
	public double FillLevel()
	{
		return (double)used / beers.length;
	}
	
	public int Collisions()
	{
		return collisions;
	}
	
	void CheckFillLevel()
	{
		if (FillLevel() > 0.75)
		{
			int newSize = (beers.length+1)*2;
			BeerRecord[] oldBeers = beers;
			beers = new BeerRecord[newSize];
			used = 0;
			for (int i=0; i < oldBeers.length; ++i)
				if (oldBeers[i] != null) Put(oldBeers[i]);
			collisions = 0;
		}
	}
	
	// hash function: 1:1 mapped id limited to length by modulus (division hashing)
	int h(int id)
	{
		return id % beers.length;
	}
	
	// linear probing
	// get position for id. 
	// free can be used in order to allow for special free record entry (put)
	int GetPosition(int id, BeerRecord free)
	{
		int position = h(id);
		while (beers[position] != null && beers[position].id != id && beers[position] != free)
		{
			position = (position+1) % beers.length; ++collisions;
		}
		return position;
	}
	
	public void Put(BeerRecord beer)
	{
		CheckFillLevel();
		int position = GetPosition(beer.id, free);
		if (beers[position] == null)
			++used;
		beers[position] = beer;
	}
	
	public BeerRecord Get(int id)
	{
		int position = GetPosition(id, null);
		return beers[position];
	}
	
	public boolean Delete(int id)
	{
		int position = GetPosition(id, null);
		if (beers[position] != null) 
		{
			--used;
			if (beers[(position+1) % beers.length] == null)
				beers[position] = null; // next entry is null, so we can safely fully remove
			else
				beers[position] = free; // otherwise fill in special free element
			return true;
		}
		else
			return false;
	}	
	
}
